% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{KostkaNumbersWithGivenLambda}
\alias{KostkaNumbersWithGivenLambda}
\title{Kostka numbers with given \eqn{\lambda}}
\usage{
KostkaNumbersWithGivenLambda(lambda, output = "vector")
}
\arguments{
\item{lambda}{integer partition}

\item{output}{the format of the output, either \code{"vector"} or 
\code{"list"}}
}
\value{
If \code{output="vector"}, this function returns a named vector. 
  This vector is made of the non-zero (i.e. positive) Kostka numbers 
  \eqn{K(\lambda,\mu)}, which are integers, and its names encode the 
  partitions \eqn{\mu}.
  If \code{output="list"}, this function returns a list of lists. 
  Each of these lists has two 
  elements. The first one is named \code{mu} and is an integer 
  partition, and the second one is named \code{value} and is a positive 
  integer, the Kostka number \eqn{K(\lambda,\mu)}. It is faster to 
  compute the Kostka numbers with this function than computing the 
  individual Kostka numbers with the function \code{\link{KostkaNumber}}.
}
\description{
Lists all positive Kostka numbers \eqn{K(\lambda,\mu)} with 
  a given partition \eqn{\lambda}.
}
\examples{
KostkaNumbersWithGivenLambda(c(2, 1, 1))
}
\seealso{
\code{\link{KostkaNumber}}, \code{\link{KostkaNumbers}}, 
  \code{\link{KostkaNumbersWithGivenMu}}.
}
