% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_outline.R
\name{plot_glyph_stats}
\alias{plot_glyph_stats}
\title{Create a visual representation of what the various glyph stats mean}
\usage{
plot_glyph_stats(
  glyph,
  family = "",
  italic = FALSE,
  weight = "normal",
  width = "undefined",
  size = 12,
  res = 72,
  variation = font_variation(),
  path = NULL,
  index = 0
)
}
\arguments{
\item{glyph}{The character to plot}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related measures}

\item{variation}{A \code{font_variation} object or a list of them to control
variable fonts}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
This function is called for its side effects
}
\description{
This function helps you understand the concepts of width, height, bearing,
and advance by annotating a glyph with the various measures
}
\examples{
plot_glyph_stats("g")

}
