% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv.R
\name{iv4}
\alias{iv4}
\title{ARX model estimation using four-stage instrumental variable method}
\usage{
iv4(z, order = c(0, 1, 0))
}
\arguments{
\item{z}{an idframe object containing the data}

\item{order}{Specification of the orders: the three integer components 
(na,nb,nk) are the order of polynolnomial A, (order of polynomial B + 1) 
and the input-output delay}
}
\value{
An object of class \code{estpoly} containing the following elements:
 \item{sys}{an \code{idpoly} object containing the 
   fitted ARX coefficients}
 \item{fitted.values}{the predicted response}
 \item{residuals}{the residuals}
 \item{input}{the input data used}
 \item{call}{the matched call}
 \item{stats}{A list containing the following fields: \cr
     \code{vcov} - the covariance matrix of the fitted coefficients \cr
     \code{sigma} - the standard deviation of the innovations\cr
     \code{df} - the residual degrees of freedom}
}
\description{
Estimates an ARX model of the specified order from input-output data using
the instrument variable method. The estimation algorithm is insensitive to 
the color of the noise term.
}
\details{
Estimation is performed in 4 stages. The first stage uses the arx function. The resulting model generates the 
instruments for a second-stage IV estimate. The residuals obtained from this model are modeled using a sufficently
high-order AR model. At the fourth stage, the input-output data is filtered through this AR model and then subjected 
to the IV function with the same instrument filters as in the second stage.
}
\examples{
mod_dgp <- idpoly(A=c(1,-0.5),B=c(0.6,-.2),C=c(1,0.6),ioDelay = 2,noiseVar = 0.1)
u <- idinput(400,"prbs")
y <- sim(mod_dgp,u,addNoise=TRUE)
z <- idframe(y,u)
mod_iv4 <- iv4(z,c(1,2,2))

}
\references{
Lennart Ljung (1999), \emph{System Identification: Theory for the User}, 
2nd Edition, Prentice Hall, New York. Section 15.3
}
\seealso{
\code{\link{arx}}, \code{\link{iv4}}
}

