% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawSyntenyPlot.R
\name{draw.eh}
\alias{draw.eh}
\title{Evolution Highway style plot}
\usage{
draw.eh(
  output,
  chrRange,
  data_file,
  directory = NULL,
  fileformat = "png",
  colour = "lightblue",
  inverted.colour = "lightpink",
  w = 5.5,
  h = 10,
  ps = 10
)
}
\arguments{
\item{output}{output file name}

\item{chrRange}{range of chromosome numbers in the reference as numbers i.e. 1:29}

\item{data_file}{file containing the syntentic blocks from the alignments}

\item{directory}{string containing file path to chosen directory to save image file}

\item{fileformat}{output file format desired using the format \code{fileformat = "png"} (default is "png")}

\item{colour}{set colour for non-inverted syntenic blocks using the format \code{colour = "red"} (default is "lightblue")}

\item{inverted.colour}{set colour for inverted syntenic blocks using the format \code{inverted.colour = "blue"} (default is "lightpink")}

\item{w}{width of output image using the format \code{w = 5.5} (default)}

\item{h}{height of output image using the format \code{h = 10} (default)}

\item{ps}{point size of output image using the format \code{ps = 10} (default)}
}
\value{
An image file showing the comparative drawings
}
\description{
Draw Evolution Highway Plots
}
\details{
This function draws Evolution Highway style plots.

It requires as input:
\enumerate{
\item Desired output file name
\item The range of chromosomes of the reference species this is entered as either a single number i.e. 1 or a range of numbers i.e. 1:22.
\emph{Note: if you are inputting sex chromosomes or chromosomes with characters in the name input a concatenated string i.e. c(1,2,3,"X")}
\item File containing the syntenic blocks of alignments of one or more target species aligned to a single reference; following this format:
reference chromosome, reference start position, reference end position, target chromosome,
target start position, target end position, orient, reference species identifier, target species identifier
}

There are optional parameters for some customization of this function:
\enumerate{
\item The format for saving the image i.e. png or pdf can be altered by inputting: \code{fileformat = "pdf"} (the default value is "png")
\item The colour of the syntenic blocks (not inverted blocks) can be changed by inputting: \code{colour = "red"} (the default value is "lightblue", see Rcolour pallette for colour options)
\item The colour of the inverted syntenic blocks can be changed by inputting: \code{inverted.colour = "blue"} (the default value is "lightpink", see Rcolour pallette for colour options)
\item The width of the image created can be changed by inputting: \code{w = 5.5}
\item The height of the image created can be changed by inputting: \code{h = 10}
\item The point size of the image created can be changed by inputting: \code{ps = 10}
\item The directory where the image file should be saved, as default the image is saved to temporary directory, change by inputting: \code{directory = "path/to/directory"}
}

The function works creating a graph for each reference chromosome using their start and end positions to create a block for the reference
and the target chromosome positions are used to colour the region where synteny was identified

Example: \code{draw.eh("outputName",c(17,"X"), "example_eh_alignments_2.txt", directory = "path/to/directory", fileformat = "pdf")}
}
\examples{

# Create object containing file path to external dataset
# (see vignette to follow examples with personal data)

file1 <- system.file("extdata", "example_eh_alignments_2.txt", package = "syntenyPlotteR")

# -----------------------------------------------------------------------------------

# Run draw.eh function
# To run example and save file to working directory
# add directory parameter and set working directory
# To run example with personal data see vignette

draw.eh("outputName", c(17, "X"), file1, fileformat = "pdf")
}
