% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knncorr.R
\name{calcknncorrWithinQuery}
\alias{calcknncorrWithinQuery}
\title{Calculates the k-NN correlation within the query cells only, which measures how well the sorted
ordering of k nearest query neighbors in a query de novo PCA embedding correlate with the ordering
for the cells in the reference mapping embedding.}
\usage{
calcknncorrWithinQuery(
  query,
  var = NULL,
  k = 100,
  topn = 2000,
  d = 20,
  distance = "euclidean"
)
}
\arguments{
\item{query}{Query object (returned from mapQuery)}

\item{var}{Query metadata batch variable (PCA is calculated within each batch separately); if NULL, do not split by batch}

\item{k}{Number of neighbors to use for kNN-correlation calculation}

\item{topn}{number of variable genes to calculate within each query batch for query PCA}

\item{d}{number of dimensions for query PCA within each query batch}

\item{distance}{either 'euclidean' or 'cosine'}
}
\value{
Vector of within-query k-NN correlations for query cells
}
\description{
Calculates the k-NN correlation within the query cells only, which measures how well the sorted
ordering of k nearest query neighbors in a query de novo PCA embedding correlate with the ordering
for the cells in the reference mapping embedding.
}
