% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack_course}
\alias{pack_course}
\title{Create an \code{.swc} file of the course you are working on}
\usage{
pack_course(export_path = NULL)
}
\arguments{
\item{export_path}{Optional, full path to the directory you want the swirl 
course file to be exported to. If not specified, then the file will appear
in the same directory as the course directory.}
}
\value{
A string, the path to the new \code{.swc} file, invisibly.
}
\description{
"Pack" the course you are working on into a single compressed file that is
easy to share. Invisibly returns the path to the \code{.swc} file.
}
\examples{
\dontrun{
# Set any lesson in the course you want to pack
set_lesson()

# Pack the course
pack_course()

# Export the .swc file to a directory that you specify
pack_course(file.path("~", "Desktop"))
}
}
