# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

removeRowsWithDuplicates <- function(inputMatrix) {
    .Call(`_swaglm_removeRowsWithDuplicates`, inputMatrix)
}

removeDuplicateRowsRegardlessOfOrder <- function(inputMatrix) {
    .Call(`_swaglm_removeDuplicateRowsRegardlessOfOrder`, inputMatrix)
}

sort_rows <- function(X) {
    .Call(`_swaglm_sort_rows`, X)
}

compute_all_possible_variable_combinations_cpp <- function(originalMatrix, idScreening) {
    .Call(`_swaglm_compute_all_possible_variable_combinations_cpp`, originalMatrix, idScreening)
}

binomial_coefficient <- function(n, k) {
    .Call(`_swaglm_binomial_coefficient`, n, k)
}

estimate_all_model_combinations_cpp <- function(X, y, matrix_of_variables, family, method) {
    .Call(`_swaglm_estimate_all_model_combinations_cpp`, X, y, matrix_of_variables, family, method)
}

identify_selected_combinations_cpp <- function(mat_of_variables, mat_criterion, alpha) {
    .Call(`_swaglm_identify_selected_combinations_cpp`, mat_of_variables, mat_criterion, alpha)
}

run_estimation_model_one_dimension_cpp <- function(X, y, family, method) {
    .Call(`_swaglm_run_estimation_model_one_dimension_cpp`, X, y, family, method)
}

my_set_seed <- function(seed) {
    invisible(.Call(`_swaglm_my_set_seed`, seed))
}

generate_permutation <- function(n, m, seed = 123L) {
    .Call(`_swaglm_generate_permutation`, n, m, seed)
}

#' swaglm 
#'
#' Run the SWAG algorithm on Generalized Linear Models specified by a \code{family} object and using the \code{fastglm} library.
#' @name swaglm
#' @param X A numeric \code{matrix} of predictors.
#' @param y A numeric \code{vector} of responses.
#' @param family A \code{family} object. Default is binomial.
#' @param p_max An \code{integer} specifying the maximum dimension to explore
#' @param method An \code{integer} scalar with value 0 for the column-pivoted QR decomposition, 1 for the unpivoted QR decomposition, 2 for the LLT Cholesky, or 3 for the LDLT Cholesky. See \code{?fastglm::fastglm}
#' @param alpha A \code{double} specifying the quantile of the criterion used to select models which are employed to construct models to explore at the next dimension
#' @param verbose A \code{boolean} used to control verbose
#' @param seed An \code{integer} that is the random seed used when creating the set of model to explore for the next dimension
#' @return An object of class \code{swaglm} structured as a \code{List} containing:
#'   - \code{lst_estimated_beta}: A \code{List} that contain the estimated coefficients for each estimated model. Each entry of this \code{List} is a matrix where in each rows are the estimated coefficients for the model.
#'   - \code{lst_p_value} A \code{List} that contain the p-value associated with each estimated coefficients for each estimated model. Each entry of this \code{List} is a matrix where in each rows are the p-value for the model.
#'   - \code{lst_AIC}: A \code{List} that contains the AIC values for each model at each dimension. Each entry of this list correspond to the AIC values for the models explored at this dimension.
#'   - \code{lst_var_mat}:  A \code{List} that that contain in each of its entries, a matrix that specify for each row a combination of variables that compose a model.
#'   - \code{lst_selected_models} A \code{List} that contain the selected models at each dimension.
#'   - \code{lst_index_selected_models} A \code{List} that contain the index of the rows corresponding to the selected models at each dimension.
#'   - \code{vec_selected_variables_dimension_1} A \code{vector} that contain the index of the selected variables at the screening step.
#'   - \code{y} The response vector used in the estimation.
#'   - \code{X} The predictor matrix used in the estimation.
#'   - \code{p_max} The maximum dimension explored by the algorithm.
#'   - \code{alpha} The selection quantile used at each step.
#'   - \code{family} The GLM family used in the estimation (e.g. \code{binomial()}).
#'   - \code{method} The method used by \code{fastglm} for estimation.
#' @example  /inst/examples/eg_swaglm.R
#' @export
swaglm <- function(X, y, p_max = 2L, family = NULL, method = 0L, alpha = 0.3, verbose = FALSE, seed = 123L) {
    .Call(`_swaglm_swaglm`, X, y, p_max, family, method, alpha, verbose, seed)
}

