% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_updatecalendarevent.R
\name{suso_gql_updatecalendarevent}
\alias{suso_gql_updatecalendarevent}
\title{Update a calendar event}
\usage{
suso_gql_updatecalendarevent(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  publicKey = NULL,
  comment = NULL,
  newStart = NULL,
  startTimezone = "UTC"
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server.}

\item{workspace}{Server Workspace, if NULL uses default.}

\item{user}{your API username.}

\item{password}{your API user password.}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored.}

\item{publicKey}{the publicKey of the calendar event to be updated.}

\item{comment}{a comment string.}

\item{newStart}{new start date, format must be: \code{2024-01-16 01:41:14}.}

\item{startTimezone}{time zone of the tablet device, use \code{\link[base]{OlsonNames}}.}
}
\value{
if successfull, returns a list with the executed mutation
}
\description{
Update a calendar event
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Update a calendar event for a specific event to 2024-01-18 01:41:14,
# in timezone Chile/Continental

suso_gql_updatecalendarevent(endpoint = ep, user = usr,
password = pass, workspace = ws, publicKey = "ea8b49c0-0d16-4fec-9029-72278e94a233",
newStart = "2024-01-16 01:41:14",
startTimezone = "Chile/Continental", comment = "Lets Go Again!")
\dontshow{\}) # examplesIf}
}
