% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_addusertomap.R
\name{suso_gql_addusertomap}
\alias{suso_gql_addusertomap}
\title{Assigns a map to a user}
\usage{
suso_gql_addusertomap(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  fileName = NULL,
  userName = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{your API user password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{fileName}{the name of the map file on the server}

\item{userName}{the name of the interviewer to whom the map will be assigned to}
}
\value{
if successfull, returns a list with the executed mutation
}
\description{
Allows the user to assign a map to an interviewer to be used in CAPI data collection.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Assign map seg_168_ALL.tif to user int0073

suso_gql_addusertomap(endpoint = ep, user = usr,
password = pass, workspace = ws,
fileName = "seg_168_ALL.tif", userName = "int0073")

\dontshow{\}) # examplesIf}
}
