% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_heuristic_optimization.R
\name{greedy_heuristic_prioritization}
\alias{greedy_heuristic_prioritization}
\title{Greedy heuristic prioritization}
\usage{
greedy_heuristic_prioritization(
  site_data,
  feature_data,
  site_probability_columns,
  site_management_cost_column,
  feature_target_column,
  total_budget,
  site_management_locked_in_column = NULL,
  site_management_locked_out_column = NULL
)
}
\arguments{
\item{site_data}{\code{\link[sf:sf]{sf::sf()}} object with site data.}

\item{feature_data}{\code{\link[base:data.frame]{base::data.frame()}} object with feature data.}

\item{site_probability_columns}{\code{character} names of \code{numeric}
columns in the argument to \code{site_data} that contain modeled
probabilities of occupancy for each feature in each site.
Each column should correspond to a different feature, and contain
probability data (values between zero and one). No missing (\code{NA})
values are permitted in these columns.}

\item{site_management_cost_column}{\code{character} name of column in the
argument to \code{site_data} that contains costs for managing each
site for conservation. This column should have \code{numeric} values that
are equal to or greater than zero. No missing (\code{NA}) values are
permitted in this column.}

\item{feature_target_column}{\code{character} name of the column in the
argument to \code{feature_data} that contains the \eqn{target}
values used to parametrize the conservation benefit of managing of each
feature.
This column should have \code{numeric} values that
are equal to or greater than zero. No missing (\code{NA}) values are
permitted in this column.}

\item{total_budget}{\code{numeric} maximum expenditure permitted
for conducting surveys and managing sites for conservation.}

\item{site_management_locked_in_column}{\code{character} name of the column
in the argument to \code{site_data} that contains \code{logical}
(\code{TRUE} / \code{FALSE}) values indicating which sites should
be locked in for (\code{TRUE}) being managed for conservation or
(\code{FALSE}) not. No missing (\code{NA}) values are permitted in this
column. This is useful if some sites have already been earmarked for
conservation, or if some sites are already being managed for conservation.
Defaults to \code{NULL} such that no sites are locked in.}

\item{site_management_locked_out_column}{\code{character} name of the column
in the argument to \code{site_data} that contains \code{logical}
(\code{TRUE} / \code{FALSE}) values indicating which sites should
be locked out for (\code{TRUE}) being managed for conservation or
(\code{FALSE}) not. No missing (\code{NA}) values are permitted in this
column. This is useful if some sites could potentially be surveyed
to improve model predictions even if they cannot be managed for
conservation. Defaults to \code{NULL} such that no sites are locked out.}
}
\value{
A \code{list} containing the following elements:
\describe{
\item{x}{\code{logical} vector indicating if each site is selected for
protection or not.}
\item{objval}{\code{numeric} value denoting the objective value for
the prioritization.}
}
}
\description{
Generate a prioritization for protected area establishment.
}
\details{
The prioritization is generated using a greedy heuristic algorithm.
The objective function for this algorithm is calculated by:
(i) estimating the probability that each species meets its target,
and (ii) calculating the sum of these probabilities.
Note that this function underpins the value of information calculations
because it is used to assess a potential management decision
given updated information on the presence of particular species
in particular sites.
}
\examples{
# set seeds for reproducibility
set.seed(123)

# load example site data
data(sim_sites)
print(sim_sites)

# load example feature data
data(sim_features)
print(sim_features)

# set total budget for managing sites for conservation
 # (i.e. 50\% of the cost of managing all sites)
total_budget <- sum(sim_sites$management_cost) * 0.5

# generate reserve selection prioritization
results <- greedy_heuristic_prioritization(
  sim_sites, sim_features,
  c("p1", "p2", "p3"),
  "management_cost",
  "target",
  total_budget
)

# print results
print(results)

}
