% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Tabulate variables}
\usage{
tab(
  ...,
  test = FALSE,
  alpha = 0.05,
  p_adjust = FALSE,
  drop_na = getOption("surveytable.drop_na"),
  max_levels = getOption("surveytable.max_levels")
)
}
\arguments{
\item{...}{names of variables (in quotes)}

\item{test}{perform hypothesis tests?}

\item{alpha}{significance level for tests}

\item{p_adjust}{adjust p-values for multiple comparisons?}

\item{drop_na}{drop missing values (\code{NA})? Categorical or logical variables only.}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}
}
\value{
A list of tables or a single table.
}
\description{
Tabulate categorical (factor or character), logical, or numeric variables.
}
\details{
For categorical and logical variables, for each category, this function presents the following:
\itemize{
\item the number of observations (\code{n});
\item the estimated count (\code{Number}), with its standard error (\code{SE}) and confidence
interval (\code{LL} and \code{UL}); and
\item the estimated percentage (\code{Percent}), with its standard error (\code{SE}) and confidence
interval (\code{LL} and \code{UL}).
}

Optionally, this function identifies low-precision estimates and flags
them if, according to the guidelines (such as the NCHS presentation standards), they should
be suppressed, footnoted, or reviewed by an analyst. To enable this functionality,
see \code{set_opts()} with arguments \code{lpe = TRUE} or \code{mode = "NCHS"}.

For numeric variables, this function presents the following:
\itemize{
\item percentage of observations with known values (\verb{\% known});
\item the mean of known values (\code{Mean}), with its standard error (\code{SEM}) and confidence
interval (\code{LL} and \code{UL}); and
\item the standard deviation (\code{SD}).
}

Confidence intervals (CIs) are calculated at the 95\% confidence level. CIs for
count estimates are the log Student's t CIs, with adaptations
for complex surveys. CIs for percentage estimates are
the Korn and Graubard CIs, with optional adjustments. See \code{set_opts()} argument
\code{adj}. CIs for estimates of means are the Wald CIs.
}
\examples{
set_survey(namcs2019sv)
tab("AGER")
tab("MDDO", "SPECCAT", "MSA")

# Numeric variables
tab("NUMMED")

# Hypothesis testing with categorical variables
tab("AGER", test = TRUE)
}
\seealso{
Other tables: 
\code{\link{tab_cross}()},
\code{\link{tab_rate}()},
\code{\link{tab_subset_rate}()},
\code{\link{total}()},
\code{\link{total_rate}()}
}
\concept{tables}
