% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlechoice.R
\name{single_summary}
\alias{single_summary}
\title{Generate a summary table for a single categorical variable, providing counts and frequencies.}
\usage{
single_summary(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The categorical variable of interest for which frequencies
and counts will be calculated, can be selected by using \strong{tidyselect}
semantics}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A tabled data frame with counts and frequencies for the specified
variable and optional grouping variable. The output is pre-processed,
considering subgroup exclusions, NA removal, and survey weights if
provided.
}
\description{
This function analyzes a specified categorical variable, \code{question},
optionally grouping by another variable, \code{group_by}. Counts and frequencies
are computed, taking into account provided survey weights. Subgroups can be
excluded, and NAs can be removed if necessary.
}
\seealso{
Other single-choice questions: 
\code{\link{single_freq}()},
\code{\link{single_table}()}
}
\concept{single-choice questions}
