% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlechoice.R
\name{single_freq}
\alias{single_freq}
\title{Plot frequencies of responses for a single-choice question.}
\usage{
single_freq(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The categorical variable of interest for which frequencies
and counts will be calculated, can be selected by using \strong{tidyselect}
semantics}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
A ggplot2 object with a bar chart displaying response frequencies. If
"group_by" is provided, facets show subgroup details. If "weights" are
specified, the chart displays weighted frequencies.
}
\description{
generates a  bar chart of class ggplot illustrating how responses are
distributed for a specific single-choice question. If you provide a grouping
variable using \code{group_by} the chart includes facets for each subgroup.
Additionally, if you specify survey weights with \code{weights} the chart reflects
weighted response frequencies.
}
\examples{


#Simple barchart
single_freq(berlinbears, question = income)

#Use `group_by` to facet the graph into several groups
single_freq(berlinbears, question = income, group_by = gender)

#to ignore a subgroup, use `subgroups_to_exclude`
single_freq(berlinbears, question = income, group_by = species,
subgroups_to_exclude = c('black bear', NA))

#Specify survey weights with `weights`
single_freq(berlinbears, question = h_winter, group_by = gender, weights = weights)

#to ignore NA values in the responses to `question`, set na.rm = TRUE
single_freq(berlinbears, question = h_winter, na.rm = TRUE)

}
\seealso{
Other single-choice questions: 
\code{\link{single_summary}()},
\code{\link{single_table}()}
}
\concept{single-choice questions}
