% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveil-package.R
\docType{package}
\name{surveil-package}
\alias{surveil-package}
\alias{surveil}
\title{The 'surveil' package}
\description{
Fits time series models for routine disease surveillance tasks and returns probability distributions for a variety of quantities of interest, including measures of health inequality, period and cumulative percent change, and age-standardized rates. Calculates Theil's index to measure inequality among multiple groups, and can be extended to measure inequality across multiple groups nested within geographies. Inference is completed using Markov chain Monte Carlo via the Stan modeling language. The models are appropriate for disease incidence and mortality data, employing a Poisson or binomial likelihood and first-difference (random-walk) prior for unknown risk, and optional covariance matrix for multiple correlated time series models.
}
\references{
Brandt P, Williams JT. Multiple time series models. Thousand Oaks, CA: SAGE Publications, 2007. ISBN:9781412906562

Clayton DG. Generalized linear mixed models. In: Gilks WR, Richardson S, Spiegelhalter DJ, editors. Markov chain Monte Carlo in practice. Boca Raton, FL: CRC Press, 1996. p. 275-302. ISBN:9780412055515

Conceicao P, Galbraith JK, Bradford P. The Theil Index in sequences of nested and hierarchic grouping structures: implications for the measurement of inequality through time, with data aggregated at different levels of industrial classification. Eastern Economic Journal 2001;27(4):491-514.

Donegan C, Hughes AE, and Lee SC (2022). Colorectal Cancer Incidence, Inequalities, and Prevention Priorities in Urban Texas: Surveillance Study With the "surveil" Software Package. \emph{JMIR Public Health & Surveillance} 8(8):e34589. \doi{10.2196/34589}

Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org

Theil H. Statistical decomposition analysis. Amsterdam, The Netherlands: North-Holland Publishing Company, 1972. ISBN:0444103783
}
\seealso{
Useful links:
\itemize{
  \item \url{https://connordonegan.github.io/surveil/}
  \item \url{https://github.com/ConnorDonegan/surveil/}
}

}
\author{
\strong{Maintainer}: Connor Donegan \email{connor.donegan@gmail.com} (\href{https://orcid.org/0000-0002-9698-5443}{ORCID})

}
