% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.survdnn.R
\name{predict.survdnn}
\alias{predict.survdnn}
\title{Predict from a survdnn Model}
\usage{
\method{predict}{survdnn}(object, newdata, times = NULL, type = c("survival", "lp", "risk"), ...)
}
\arguments{
\item{object}{An object of class `"survdnn"` returned by [survdnn()].}

\item{newdata}{A data frame of new observations to predict on.}

\item{times}{Numeric vector of time points at which to compute survival or risk probabilities.
Required if `type = "survival"` or `type = "risk"` for Cox/AFT models.
For CoxTime, `times = NULL` is allowed when `type="survival"` and defaults to event times.}

\item{type}{Character string specifying the type of prediction to return:
\describe{
  \item{"lp"}{Linear predictor. For `"cox"`/`"cox_l2"` this is a log-risk score
  (higher implies worse prognosis, consistent with training sign convention). For `"aft"`,
  this is the predicted location parameter \eqn{\mu(x)} on the log-time scale. For `"coxtime"`,
  this is \eqn{g(t_0, x)} evaluated at a reference time \eqn{t_0} (the first event time).}
  \item{"survival"}{Predicted survival probabilities at each value of `times`.}
  \item{"risk"}{Cumulative risk (1 - survival) at **a single** time point.}
}}

\item{...}{Currently ignored (for future extensions).}
}
\value{
A numeric vector (if `type = "lp"` or `"risk"`), or a data frame
  (if `type = "survival"`) with one row per observation and one column per `times`.
}
\description{
Generate predictions from a fitted `survdnn` model for new data. Supports linear predictors,
survival probabilities at specified time points, or cumulative risk estimates.
}
