% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_report.R
\name{validation_report}
\alias{validation_report}
\title{Generate survival model validation report}
\usage{
validation_report(
  train_data,
  val_data,
  model,
  time_col,
  status_col,
  times = c(365, 730, 1095),
  time_unit = "days",
  output = NULL
)
}
\arguments{
\item{train_data}{training dataset containing survival outcomes.}

\item{val_data}{validation dataset containing survival outcomes.}

\item{model}{fitted 'coxph'}

\item{time_col}{name of the survival time column present in both datasets}

\item{status_col}{name of the event indicator column present in both datasets}

\item{times}{follow-up timepoints}

\item{time_unit}{character label for the time axis (default = "days")}

\item{output}{file path (.pptx or .html). Defaults to a temporary file.}
}
\value{
Invisibly returns the file path containing the validation report
}
\description{
Generate survival model validation report
}
