% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_histograms.R
\name{display.obs.histogram}
\alias{display.obs.histogram}
\title{Auxiliar function that displays the concordance histogram associated with the observation.}
\usage{
display.obs.histogram(histograms, type, obs.index)
}
\arguments{
\item{histograms}{The histograms object returned by the survBootOutliers function when the method selected is "bht" or "dbht".}

\item{type}{The type of histogram that is given as input, possible choices are again "bht" or "dbht".}

\item{obs.index}{The original index of the observation of the concordance histograms to be displayed}
}
\value{
No value is returned
}
\description{
Auxiliar function that displays the concordance histogram associated with the observation.
}
\examples{
\dontrun{
whas <- get.whas100.dataset()
outliers_bht <- survBootOutliers( 
      surv.object=Surv(time = whas$times,event = whas$status ), 
     covariate.data = whas[,2:5], 
     sod.method = "bht", 
     B = 2000, B.N = 100 , 
     parallel.param = BiocParallel::MulticoreParam() 
)
display.obs.histogram(outliers_bht$histograms, "bht", 67)
}

}
