% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab1.R
\name{tab1}
\alias{tab1}
\title{Summarise a categorial variable}
\usage{
tab1(data, variable, dp = 1)
}
\arguments{
\item{data}{The data frame or tibble}

\item{variable}{The categorical variable you would like to summarise}

\item{dp}{The number of decimal places for percentages (default=2)}
}
\value{
A tibble with frequencies and percentages
}
\description{
Summarises frequencies and percentages for a categorical variable.

The function accepts an input from a dplyr pipe "\%>\%" and outputs the results as a tibble.
eg. example_data \%>\% tab1(variable)
}
\examples{
example_data <- dplyr::tibble(id = 1:100, group = sample(c("a", "b", "c", "d"),
                                                  size = 100, replace = TRUE))
example_data$group[sample(1:100, size = 10)] <- NA  # Replace 10 with missing
tab1(example_data, group)
summary <- tab1(example_data, group) # Save summary statistics as a tibble.
}
