% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_classification.R
\name{topic_classification}
\alias{topic_classification}
\title{Topic Classification for Narrative Data}
\usage{
topic_classification(
  data,
  narratives,
  sentences,
  sentences_lda,
  sentence_polarity,
  data_annotated,
  use_beta,
  use_seeds,
  nr_topics,
  seeded_topics,
  competencies
)
}
\arguments{
\item{data}{A data frame or data.table containing metadata and other relevant data for topic classification.}

\item{narratives}{A data frame or data.table containing the narrative data, including comments and feedback.}

\item{sentences}{A data frame or data.table containing the sentences to be classified, including the text and metadata.}

\item{sentences_lda}{A result object from LDA topic modeling, which contains the topic distribution for each term.}

\item{sentence_polarity}{A data frame or data.table containing sentence-level polarity scores (sentiment analysis results).}

\item{data_annotated}{A data frame or data.table containing the lemmatized text and other annotations.}

\item{use_beta}{A logical value indicating whether to use the \code{beta} values from the LDA model for topic classification.}

\item{use_seeds}{A logical value indicating whether to incorporate seeded topics for topic classification.}

\item{nr_topics}{An integer specifying the number of topics to classify.}

\item{seeded_topics}{A list of character vectors representing the topics with predefined seed words.}

\item{competencies}{A list of mames of the competencies per id as used in the data set}
}
\value{
A data.table containing the classified sentences with the following columns:
\itemize{
\item \code{sentenceid}: Unique identifier for each sentence.
\item \code{sentence}: The sentence text.
\item \code{polarity}: The sentiment polarity score of the sentence.
\item \code{max_probability}: The highest topic probability for each sentence.
\item Additional columns corresponding to each topic, representing the probability of the sentence belonging to that topic.
\item Metadata fields such as \code{document}, \code{submissionid}, \code{competencyid}, \code{feedbacktype}, \code{score}, and \code{comment}.
}
}
\description{
This function classifies sentences from narrative data into topics based on Latent Dirichlet Allocation (LDA) topic modeling results. It integrates additional features like sentiment analysis, annotated data, and seeded topics to enhance the classification.
}
\details{
The \code{topic_classification} function integrates several sources of data to classify sentences into topics:
\itemize{
\item It uses LDA topic modeling results to assign a probability for each topic.
\item The function can incorporate seeded topics, which enhance the classification by matching predefined keywords to the topics.
\item Sentiment analysis is used to add polarity scores to the sentence data.
\item The output includes additional metadata for each sentence, such as feedback type, score, and associated comments.
}
}
