% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_clean.R
\name{text_clean}
\alias{text_clean}
\title{Text Cleaning and Processing Functions}
\usage{
text_clean(data, corrections_file)
}
\arguments{
\item{data}{A data.table or data.frame containing text data.}

\item{corrections_file}{Path to a CSV file containing typo corrections.}
}
\value{
A cleaned dataset with standardized text.
}
\description{
This file contains helper functions for text processing and cleaning used in the 'sumup' package.
The functions provide capabilities for text correction, cleaning, dataset preparation, and handling abbreviation replacements.

Cleans narrative text columns (\code{sterk}, \code{verbeter}, \code{feedback}) in a dataset.
}
\author{
Joyce M.W. Moonen - van Loon

This file defines several functions:
\itemize{
\item \code{text_clean()}: Cleans multiple columns in a dataset.
\item \code{correct_text()}: Applies typo corrections using a predefined correction list.
\item \code{clean_text()}: Cleans and formats input text, handling HTML tags, spacing, punctuation, and typos.
\item \code{get_corrections()}: Reads a correction file and processes typo replacements.
\item \code{create_dataset_narratives()}: Prepares a dataset by restructuring and normalizing its textual content.
\item \code{replace_abbr()}: Corrects abbreviations.
}
}
