% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_glyph.R
\name{theme_glyph}
\alias{theme_glyph}
\title{Customized Theme for Glyph Plots}
\usage{
theme_glyph(
  control = list(plot.title = rel(1.5), plot.subtitle = rel(1.3), plot.caption = rel(1),
    legend.text = rel(1), legend.title = rel(1))
)
}
\arguments{
\item{control}{A list specifying the relative font sizes for different plot elements.
The list can contain the following components:
\describe{
  \item{plot.title}{Font size for the plot title (default: \code{rel(1.5)}).}
  \item{plot.subtitle}{Font size for the plot subtitle (default: \code{rel(1.3)}).}
  \item{plot.caption}{Font size for the plot caption (default: \code{rel(1)}).}
  \item{legend.text}{Font size for the legend text (default: \code{rel(1)}).}
  \item{legend.title}{Font size for the legend title (default: \code{rel(1)}).}
}}
}
\value{
A ggplot2 theme object with customized settings for glyph plots.
}
\description{
`theme_glyph()` provides a customized theme for glyph maps,
built on top of `theme_map()` from `ggthemes`. It adjusts the plot's appearance, including
the legend position, text styles, and background settings, to create
a clean, visually consistent layout for glyph visualizations.
}
\details{
This theme includes:
\itemize{
  \item Legend positioned inside the plot, at the bottom left corner.
  \item Horizontal legend direction with `mono` font for text.
  \item Centered plot titles with bold, `mono` font.
  \item `mono` fonts for subtitles and captions.
  \item White background for both the panel and plot.
}
}
\examples{
library(ggplot2)
library(ozmaps)

aus_temp |>
  ggplot(aes(x_major = long, y_major = lat,
             x_minor = month, ymin_minor = tmin,
             ymax_minor = tmax)) +
 geom_sf(data = abs_ste, fill = "antiquewhite",
         inherit.aes = FALSE, color = "white") +
 add_glyph_boxes() +
 add_ref_lines() +
 geom_glyph_ribbon() +
 theme_glyph()

}
\seealso{
[ggthemes::theme_map()], [ggplot2::theme()]
}
