% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antimicrobial_analysis.R
\name{antimicrobial_analysis}
\alias{antimicrobial_analysis}
\title{Antimicrobial Data Analysis}
\arguments{
\item{zone_data}{A data frame containing the results of antimicrobial testing, with the following columns:
'bacterial_strain', 'antimicrobial_agent', 'zone_inhibition', and 'contact_area'.}

\item{seed}{Optional. A numeric value to set the seed for reproducibility. If NULL (default), no seed is set.}
}
\value{
A list containing the results of the antimicrobial analysis, including:
\itemize{
  \item \strong{Summary statistics} of the zone of inhibition per bacterial strain and antimicrobial agent.
  \item \strong{Chi-square test results} for associations between bacterial strain and contact area.
  \item \strong{Boxplot} visualizing the distribution of zone of inhibition across antimicrobial treatments and bacterial strains.
  \item \strong{Heatmap} displaying zone of inhibition values across bacterial strains and antimicrobial agents.
  \item \strong{ANOVA and Tukey HSD test results} for differences in zone of inhibition across treatments.
  \item \strong{Linear model diagnostics} including residuals vs. fitted for model assumptions.
  \item \strong{MDS plot} representing similarity of samples in reduced dimensions based on zone of inhibition.
  \item \strong{Random forest model} used to classify bacterial response based on zone of inhibition.
  \item \strong{Variable importance results} identifying key predictors from the random forest model.
  \item \strong{Variable importance plot} visualizing the most influential variables in the classification task.
}
}
\description{
Analyzes and visualizes antimicrobial test data through a combination of descriptive statistics, inferential analyses (ANOVA, Tukey HSD, Chi-square),
and multivariate techniques including Multidimensional Scaling (MDS), and Random Forest classification.
This function provides insights into group differences, underlying data structure, and variable importance in antimicrobial activity.
}
\examples{
# EXAMPLE 1: Two Bacterial Strain
bacterial_strain = rep(c("S. aureus", "K. pneumoniae"), each = 12)
antimicrobial_agent = rep(rep(c("Control", "HGS1 (30\% wet pick-up)", "HGS2 (50\% wet pick-up)",
                                "HGS3 (80\% wet pick-up)"), each = 3), times = 2)
zone_inhibition = c(0, 0, 0, 10.2, 11.0, 9.8, 14.1, 13.8, 15.0, 18.5, 17.9, 19.2,
                    0, 0, 0, 8.5, 9.0, 8.8, 12.7, 13.1, 12.9, 16.4, 15.8, 16.9)
contact_area = c("Growth", "Growth", "Growth", "Partial Growth",
                 "Growth", "Partial Growth", "No Growth", "No Growth",
                 "Partial Growth", "No Growth", "No Growth", "No Growth",
                 "Growth", "Growth", "Growth", "Growth",
                 "Partial Growth", "Growth", "Partial Growth", "No Growth",
                 "No Growth", "No Growth", "No Growth", "No Growth")
zone_data <- data.frame(bacterial_strain, antimicrobial_agent, zone_inhibition, contact_area)
antimicrobial_analysis(zone_data)                 # seed = NULL, no seed is set
antimicrobial_analysis(zone_data, seed = 123)     # seed is set to ensure reproducible results

# EXAMPLE 2: Four Bacterial Strain
bacterial_strain = rep(c("S. aureus", "K. pneumoniae", "E. coli", "S. pneumoniae"), each = 12)
antimicrobial_agent = rep(rep(c("Control", "HGS1 (30\% wet pick-up)", "HGS2 (50\% wet pick-up)",
                                "HGS3 (80\% wet pick-up)"), each = 3), times = 4)
zone_inhibition = c(0, 0, 0, 10.2, 11.0, 9.8, 14.1, 13.8, 15.0, 18.5, 17.9, 19.2,
                    0, 0, 0, 8.5, 9.0, 8.8, 12.7, 13.1, 12.9, 16.4, 15.8, 16.9,
                    0, 0, 0, 9.3, 8.9, 9.1, 13.0, 13.5, 13.2, 16.7, 17.0, 16.9,
                    0, 0, 0, 11.5, 11.2, 11.0, 15.2, 14.9, 15.0, 19.0, 18.7, 19.3)
contact_area = c("Growth", "Growth", "Growth", "Partial Growth",
                 "Growth", "Partial Growth", "No Growth", "No Growth",
                 "Partial Growth", "No Growth", "No Growth", "No Growth",
                 "Growth", "Growth", "Growth", "Growth",
                 "Partial Growth", "Growth", "Partial Growth", "No Growth",
                 "No Growth", "No Growth", "No Growth", "No Growth",
                 "Growth", "Growth", "Growth", "Partial Growth",
                 "Partial Growth", "Growth", "Partial Growth", "No Growth",
                 "Partial Growth", "No Growth", "No Growth", "No Growth",
                 "Growth", "Growth", "Growth", "Partial Growth",
                 "Partial Growth", "Growth", "No Growth", "No Growth",
                 "Partial Growth", "No Growth", "No Growth", "No Growth")
zone_data <- data.frame(bacterial_strain, antimicrobial_agent, zone_inhibition, contact_area)
antimicrobial_analysis(zone_data)                 # seed = NULL, no seed is set
antimicrobial_analysis(zone_data, seed = 123)     # seed is set to ensure reproducible results

}
\author{
Paul Angelo C. Manlapaz
}
