% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/istitle.R
\name{strs_istitle}
\alias{strs_istitle}
\title{Check if string is in title case}
\usage{
strs_istitle(string)
}
\arguments{
\item{string}{A character vector where each element is a string to be
checked.}
}
\value{
A logical vector of the same length as \code{string}, indicating whether
each element is in title case.
}
\description{
\code{strs_istitle} checks whether each element of a character vector is title
case. This is similar to Python's \code{str.istitle} method.
}
\examples{
strs_istitle("This Is Title Case")
strs_istitle("not title case")
strs_istitle("123 Another Example")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.istitle}{Python str.istitle() documentation}
}
