% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/after.R, R/before.R
\name{before-and-after}
\alias{before-and-after}
\alias{str_after_nth}
\alias{str_after_first}
\alias{str_after_last}
\alias{str_before_nth}
\alias{str_before_first}
\alias{str_before_last}
\title{Extract text before or after \code{n}th occurrence of pattern.}
\usage{
str_after_nth(string, pattern, n)

str_after_first(string, pattern)

str_after_last(string, pattern)

str_before_nth(string, pattern, n)

str_before_first(string, pattern)

str_before_last(string, pattern)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:about_search_regex]{stringi::about_search_regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:modifiers]{coll()}. For details see \code{\link[stringr:modifiers]{stringr::regex()}}.}

\item{n}{A vector of integerish values. Must be either length 1 or
have length equal to the length of \code{string}. Negative indices count from
the back: while \code{n = 1} and \code{n = 2} correspond to first and second, \code{n = -1} and \code{n = -2} correspond to last and second-last. \code{n = 0} will return
\code{NA}.}
}
\value{
A character vector.
}
\description{
Extract the part of a string which is before or after the \code{n}th occurrence of
a specified pattern, vectorized over the string.
}
\details{
\itemize{ \item \code{str_after_first(...)} is just \code{str_after_nth(..., n = 1)}.
\item \code{str_after_last(...)} is just \code{str_after_nth(..., n = -1)}. \item
\code{str_before_first(...)} is just \code{str_before_nth(..., n = 1)}. \item
\code{str_before_last(...)} is just \code{str_before_nth(..., n = -1)}. }
}
\examples{
string <- "abxxcdxxdexxfgxxh"
str_after_nth(string, "xx", 3)
str_before_nth(string, "e", 1:2)
str_before_nth(string, "xx", -3)
str_before_nth(string, ".", -3)
str_before_nth(rep(string, 2), "..x", -3)
str_before_first(string, "d")
str_before_last(string, "x")
string <- c("abc", "xyz.zyx")
str_after_first(string, ".") # using regex
str_after_first(string, coll(".")) # using human matching
str_after_last(c("xy", "xz"), "x")
}
\seealso{
Other bisectors: 
\code{\link{str_before_last_dot}()}
}
\concept{bisectors}
