#' Financial stress index component data.
#' @description Fetches financial stress index component data as time series and provides plots.
#' @details Downloads the financial stress index component daily data in its original XLS format from the Federal Reserve Bank of Cleveland's web site, and then translates that data into an \code{xts} time series object with stress component value histories as columns.  Provides custom \code{lattice} line and area plot functions for data presentation.
#' @author Matt Barry \email{mrb@@softisms.com}
#' @references Federal Reserve Bank of Cleveland research data site \url{http://www.clevelandfed.org/research/data/financial_stress_index/index.cfm}
#' @keywords FRB financial stress index component
#' @name stressr
#' @docType package
NULL
