% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_refit.R
\name{mlm_refit}
\alias{mlm_refit}
\title{Refit Machine Learning Models}
\usage{
mlm_refit(mlm_object, train_data, test_data, classification = FALSE)
}
\arguments{
\item{mlm_object}{A `"mlm_stressor"` object.}

\item{train_data}{A data.frame object used for refitting excludes the test
data. Can be `NULL` to allow for predictions to be used on the current
model.}

\item{test_data}{A data.frame object used for predictions.}

\item{classification}{A Boolean value used to represent if classification
methods need to be used to refit the data.}
}
\value{
A matrix with the predictions of the various machine learning
  methods.
}
\description{
Refits models fitted in the \link[stressor]{mlm_init}, and returns the
 predictions.
}
\examples{
\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 lm_train <- data_gen_lm(20)
 train_idx <- sample.int(20, 5)
 train <- lm_train[train_idx, ]
 test <- lm_train[-train_idx, ]
 create_virtualenv()
 mlm_lm <- mlm_regressor(Y ~ ., lm_train)
 mlm_refit(mlm_lm, train, test, classification = FALSE)
\dontshow{\}) # examplesIf}
}
