% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_reach_dist.R
\name{prep_reach_dist}
\alias{prep_reach_dist}
\title{Calculate the distance from a well to each reach within a stream network. This function splits a polyline stream network up into a series of evenly spaced points and
calculates the distance from each of those points to a well.}
\usage{
prep_reach_dist(
  wel_lon,
  wel_lat,
  stream_sf,
  reach_id,
  stream_pt_spacing,
  nseed = 1
)
}
\arguments{
\item{wel_lon}{longitude of well}

\item{wel_lat}{latitude of well}

\item{stream_sf}{simple feature collection of stream lines, i.e., loaded from a shapefile using \code{sf::st_read}.}

\item{reach_id}{string indicating name of column in \code{stream_sf} that has the unique identifier for each stream line segment.}

\item{stream_pt_spacing}{distance between points used for sampling each stream reach. The actual distance
between points will be close to this (but not necessarily exact) due to sampling rounding error. The finer
spacing you use, the more accurate your results will be but the function will run slower and use more memory.}

\item{nseed}{seed for random number generator (this is used to convert stream polylines to points)}
}
\value{
A data frame with four columns:
\describe{
  \item{reach}{a grouping variable with the name of each stream reach}
  \item{dist}{distance of a point on that stream reach to the well of interest}
  \item{lat}{latitude of that point}
  \item{lon}{longitude of that point}
}
This data frame can be plugged directly into \link{apportion_inverse}, \link{apportion_polygon} (if \code{latlon=T}),
or \link{apportion_web}
}
\description{
Calculate the distance from a well to each reach within a stream network. This function splits a polyline stream network up into a series of evenly spaced points and
calculates the distance from each of those points to a well.
}
\examples{
rdll <- prep_reach_dist(wel_lon = 295500, wel_lat = 4783200,
   stream_sf = stream_lines, reach_id = "reach", stream_pt_spacing = 5)
head(rdll)
}
