% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategicplayers.R
\name{sp}
\alias{sp}
\title{sp}
\usage{
sp(n.players, gd, targets, avoiders, theta = 0.5, n.loops = 1000)
}
\arguments{
\item{n.players}{the number of intervention subjects you wish to identify}

\item{gd}{a matrix of geodesic distances for the network of interest}

\item{targets}{a vector of indicies of the people you want to spread the intervention to}

\item{avoiders}{a vector of indicies of the people you don't want to spread the intervention to}

\item{theta}{a number between 0 and 1 which weights the distance metric, 1 only prioritizes closeness to targets, 0 only prioritizes maximizing distance from avoiders.  Any number between 0 and 1 will be a compromise of these two goals.}

\item{n.loops}{the number of loops to run, the more loops you run the more likely you are to identify the optimal set of strategic players}
}
\value{
returns the indicies for strategic players
}
\description{
Takes in the number of intervention subjects you wish to identify, geodesic distances, targets, avoiders, and a parameter that prioritizes avoiding vs targetting, and returns the indecies of the strategic players
}

