% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc_temporal}
\alias{mcmc_temporal}
\title{Bayesian Estimation of Temporal Hawkes Model Parameters}
\usage{
mcmc_temporal(
  times,
  t_max = max(times),
  t_mis = NULL,
  param_init = NULL,
  mcmc_param = NULL,
  branching = TRUE,
  print = TRUE
)
}
\arguments{
\item{times}{- vector of arrival times}

\item{t_max}{- maximum time value (default = max(times))}

\item{t_mis}{- \eqn{M}x\eqn{2} matrix, mth row contains two elements describing the mth missing time range (default = `NULL`)}

\item{param_init}{- list of parameters of initial guess (default = `NULL`, will start with MLE)}

\item{mcmc_param}{- list of mcmc parameters}

\item{branching}{- using branching structure in estimation (default = `TRUE`)}

\item{print}{- print progress (default = `TRUE`)}
}
\value{
A List containing the mcmc samples (samps), branching structure (`y`, if `TRUE`), and missing data (`zsamps` if `t_mis` is not `NULL`)
If `t_mis` is not `NULL` the mcmc samples will contain `n_missing`, the number of missing points estimated
}
\description{
This function computes the posterior of the parameters of a temporal exponential decay Hawkes model
using Metropolis-with-in-Gibbs sampling.
}
\details{
The default is to estimate the branching structure which is much more computationally efficient. The model will also account to missing data if \code{t_mis} is provided.

Branching models specify gamma priors for mu, alpha and beta parameters.
}
\examples{
\donttest{
times = simulate_temporal(.5,.1,.5,c(0,10),numeric())
out = mcmc_temporal(times)
}
}
