% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stodom_functions.R
\name{fo_stodom}
\alias{fo_stodom}
\title{first-order stochastic dominance test}
\usage{
fo_stodom(data_1, data_2, bins_size, n_draws, useed, variable_1, variable_2, type)
}
\arguments{
\item{data_1}{data 1.}

\item{data_2}{data 2.}

\item{bins_size}{bin size.}

\item{n_draws}{number of draws to compute p values (default = 500).}

\item{useed}{user defined seed}

\item{variable_1}{name of a (as a string); only for the output table (default = "a").}

\item{variable_2}{name of b (as a string); only for the output table (default = "b").}

\item{type}{type of bootstrapped test, bootstrapping 1 and 2 of Barrett and Donald (2003) are available (default = "boot2").}
}
\value{
The function returns a list object containing the p-values of two dominance tests (i.e., variable 1 vs. variable 1 and variable 2 vs. variable 1).
}
\description{
This function tests for first-order stochastic dominance.
}
\details{
This function computes the consistent test of first-order stochastic dominance following Barrett and Donald (2003). In detail, this function estimate their Kolmogorov-Smirnov type tests based on bootstrapping 2. The function was implemented as part of Schaub xxx
}
\examples{

# load stodom
require(stodom)

 data_a <- rnorm(500, 3, 2)
 data_b <- rnorm(500, 1, 2)

# estimate first-order stochastic dominance
fo_stodom(data_1 = data_a, data_2 = data_b, n_draws = 100, useed = 1, bins_size = 1)
}
\references{
Barrett, G. F., & Donald, S. G. (2003). Consistent tests for stochastic dominance. Econometrica, 71(1), 71-104.

Schaub, S. & El Benni, N. (2024). How do price (risk) changes influence farmers’ preference to reduce fertilizer application?
}
