% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optSV.R
\name{predict.stochvolTMB}
\alias{predict.stochvolTMB}
\title{Predict future returns and future volatilities}
\usage{
\method{predict}{stochvolTMB}(object, steps = 1L, nsim = 10000, include_parameters = TRUE, ...)
}
\arguments{
\item{object}{A \code{stochvolTMB} object returned from \code{\link{estimate_parameters}}.}

\item{steps}{Integer specifying number of steps to predict.}

\item{nsim}{Number of draws from the predictive distribution.}

\item{include_parameters}{Logical value indicating if fixed parameters 
should be simulated from their asymptotic distribution, i.e. 
multivariate normal with inverse hessian as covariance matrix.}

\item{...}{Not is use.}
}
\value{
List of simulated values from the predictive distribution of the latent volatilities and log-returns.
}
\description{
Takes a \code{stochvolTMB} object and produces draws from the predictive distribution of the latent volatility 
and future log-returns.
}
