% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{seasonal}
\alias{fc}
\alias{fitted.stl}
\alias{fitted.stlplus}
\alias{getraw}
\alias{predict.stl}
\alias{predict.stlplus}
\alias{remainder}
\alias{remainder.stl}
\alias{remainder.stlplus}
\alias{seasonal}
\alias{seasonal.stl}
\alias{seasonal.stlplus}
\alias{time.stl}
\alias{time.stlplus}
\alias{trend}
\alias{trend.stl}
\alias{trend.stlplus}
\title{Accessor functions for elements of an stl and stlplus object}
\usage{
seasonal(object)

trend(object)

remainder(object)

getraw(object)

\method{remainder}{stlplus}(object)

\method{fitted}{stlplus}(object, ...)

\method{predict}{stlplus}(object, ...)

\method{seasonal}{stlplus}(object)

\method{trend}{stlplus}(object)

fc(object, fcnum = 1)

\method{time}{stlplus}(x, ...)

\method{remainder}{stl}(object)

\method{seasonal}{stl}(object)

\method{trend}{stl}(object)

\method{time}{stl}(x, ...)

\method{predict}{stl}(object, ...)

\method{fitted}{stl}(object, ...)
}
\arguments{
\item{fcnum}{number of post-trend smoothing frequency component.}

\item{x, object}{object of class \code{"stl"} or \code{"stlplus"}.}

\item{\ldots}{additional parameters}
}
\value{
Returns a vector of either the \code{getraw} time series, the \code{seasonal}, \code{trend}, or \code{remainder} components, or the \code{time} values of the time series.  If \code{time}s are requested but were not supplied in the initial \code{stlplus} call, the \code{1:n} vector is returned, where \code{n} is the number of data points.  The \code{fitted} method returns the sum of the seasonal and trend.
}
\description{
Retrieves the raw, seasonal, trend, remainder, or time components from an stlplus object.  The methods \code{seasonal.stl}, ... also exist as a convenience for extracting components from R's \code{stl()}.
}
\note{
The \code{fitted} and \code{predict} methods are equivalent.  For objects of class \code{"stlplus"}, these functions return the sum of all components but the remainder, including post-trend smoothing components.  Note also that the \code{trend} method for objects of class \code{"stlplus"} only returns the trend component from the STL iterations, even when post-trend smoothing is done.
}
\examples{
co2.stl <- stlplus(co2, t = as.vector(stats::time(co2)), n.p=12, l.window=13,
t.window=19, s.window=35, s.degree=1, sub.labels = substr(month.name, 1, 3))

plot(seasonal(co2.stl))
}
\references{
R. B. Cleveland, W. S. Cleveland, J.E.  McRae, and I. Terpenning (1990) STL:  A  Seasonal-Trend  Decomposition  Procedure Based on Loess. \emph{Journal of Official Statistics}, \bold{6}, 3--73.
}
\seealso{
\code{\link{stlplus}}
}

