% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop.ps}
\alias{ci.prop.ps}
\title{Confidence interval for a paired-samples proportion difference}
\usage{
ci.prop.ps(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion difference
\item SE - adjusted standard error
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes an adjusted Wald confidence interval for a difference of
population proportions in a paired-samples design. This function requires
the frequency counts from a 2 x 2 contingency table for two repeated
dichotomous measurements.

For more details, see Section 3.2 of Bonett (2021, Volume 3)
}
\examples{
ci.prop.ps(.05, 12, 4, 26, 6)

# Should return:
# Estimate         SE        LL        UL
#     0.44 0.09448809 0.2548067 0.6251933


}
\references{
\insertRef{Bonett2012}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
