% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{opttest}
\alias{opttest}
\title{Optionally test code depending on environment variable.}
\usage{
opttest(
  expr,
  testname = NULL,
  testvar = "ENABLE_statnet_TESTS",
  yesvals = c("y", "yes", "t", "true", "1"),
  lowercase = TRUE
)
}
\arguments{
\item{expr}{An expression to be evaluated only if \code{testvar} is set to a
non-empty value.}

\item{testname}{Optional name of the test. If given, and the test is
skipped, will print a message to that end, including the name of the test,
and instructions on how to enable it.}

\item{testvar}{Environment variable name. If set to one of the
\code{yesvals}, \code{expr} is run. Otherwise, an optional message is
printed.}

\item{yesvals}{A character vector of strings considered affirmative values
for \code{testvar}.}

\item{lowercase}{Whether to convert the value of \code{testvar} to lower
case before comparing it to \code{yesvals}.}
}
\description{
A convenience wrapper to run code based on whether an environment variable
is defined.
}
\keyword{debugging}
\keyword{environment}
\keyword{utilities}
