% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize}
\alias{summarize}
\alias{summarize.default}
\alias{summarize.htest}
\alias{summarize.lm}
\alias{summarize.glm}
\alias{summarize.polr}
\alias{summarize.lme}
\alias{summarize.lmerMod}
\alias{summarize.glmerMod}
\alias{summarize.gam}
\alias{summarize.survreg}
\alias{summarize.coxph}
\alias{summarize.rpart}
\title{Summarize statistical output}
\usage{
summarize(object, ...)

\method{summarize}{default}(object, ...)

\method{summarize}{htest}(object, ...)

\method{summarize}{lm}(object, ...)

\method{summarize}{glm}(object, ...)

\method{summarize}{polr}(object, ...)

\method{summarize}{lme}(object, ...)

\method{summarize}{lmerMod}(object, ...)

\method{summarize}{glmerMod}(object, ...)

\method{summarize}{gam}(object, ...)

\method{summarize}{survreg}(object, ...)

\method{summarize}{coxph}(object, ...)

\method{summarize}{rpart}(object, ...)
}
\arguments{
\item{object}{An object for which a summary is desired (e.g., a
\link[stats:glm]{glm} object).}

\item{...}{Additional optional arguments. (Currently ignored.)}
}
\value{
A character string summarizing the statistical output.
}
\description{
Generate text-based summaries of statistical output that can be embedded into
prompts for querying Large Language Models (LLMs). Intended primarily for
internal use.
}
\examples{
tt <- t.test(1:10, y = c(7:20))
summarize(tt)  # prints output as a character string
cat(summarize(tt))  # more useful for reading

}
\seealso{
\link[base:summary]{summary()}.
}
