% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{EMFA}
\alias{EMFA}
\title{Factor analytic variation of EM algoritm}
\usage{
EMFA(
  y,
  k,
  size_param_x = NULL,
  cmHet = TRUE,
  dmHet = TRUE,
  tolerance = 1e-06,
  maxIter = 300L,
  size_param_cmStart = NULL,
  size_param_dmStart = NULL,
  mG = 1L,
  mE = 1L,
  maxDiag = 10000,
  stopIfDecreasing = TRUE,
  traits = ""
)
}
\arguments{
\item{y}{An n x p matrix of observed phenotypes, on p traits or environments
for n individuals. No missing values are allowed.}

\item{k}{An n x n kinship matrix.}

\item{size_param_x}{An n x c covariate matrix, c being the number of
covariates and n being the number of genotypes. c has to be at least one
(typically an intercept). No missing values are allowed. If not provided a
vector of 1s is used.}

\item{cmHet}{Should an extra diagonal part be added in the model for the
precision matrix Cm?}

\item{dmHet}{Should an extra diagonal part be added in the model for the
precision matrix Dm?}

\item{tolerance}{A numerical value. The iterating process stops if the
difference in conditional log-likelihood between two consecutive iterations
drops below tolerance.}

\item{maxIter}{A numerical value for the maximum number of iterations.}

\item{size_param_cmStart}{A p x p matrix containing starting values for the
precision matrix Cm.}

\item{size_param_dmStart}{A p x p matrix containing starting values for the
precision matrix Dm.}

\item{mG}{An integer. The order of the genetic part of the model.}

\item{mE}{An integer. The order of the environmental part of the model.}

\item{maxDiag}{A numical value. The maximal value of the diagonal elements
in the precision matrices Cm and Dm (ignoring the low-rank part W W^t)}

\item{stopIfDecreasing}{Should the iterating process stop if after 50
iterations the log-likelihood decreases between two consecutive iterations?}
}
\value{
A list containing the following components
\itemize{
\item{\code{Vg} The genetic variance components matrix.}
\item{\code{Ve} The environmental variance components matrix.}
}
}
\description{
Implementation of the factor analytic variation of the EM algoritm as
proposed by Dahl et al. (2013).
}
\references{
Dahl et al. (2013). Network inference in matrix-variate Gaussian
models with non-independent noise. arXiv preprint arXiv:1312.1622.

Zhou, X. and Stephens, M. (2014). Efficient multivariate linear
mixed model algorithms for genome-wide association studies. Nature Methods,
February 2014, Vol. 11, p. 407–409
}
\keyword{internal}
