% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_statdecide.R
\name{run_statdecide}
\alias{run_statdecide}
\title{Run Statistical Decision Workflow}
\usage{
run_statdecide(data, dep_var, group_vars, cld_offset = 5, verbose = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{dep_var}{Character. Name of the dependent variable.}

\item{group_vars}{Character vector. One or two grouping variables.}

\item{cld_offset}{Numeric. Vertical offset to place CLD labels above the boxplot (default: 5).}

\item{verbose}{Logical. Whether to print progress messages and results (default: TRUE).}
}
\value{
A list containing:
\describe{
\item{normality_test}{Results of Shapiro-Wilk test}
\item{main_effects}{Results for each main effect}
\item{interaction}{Interaction results (if 2 group_vars)}
\item{plots}{List of ggplot objects}
\item{facet_plot}{Faceted ggplot (if 2 group_vars)}
\item{heatmap}{Heatmap ggplot (if 2 group_vars)}
}
}
\description{
Automatically checks normality, selects appropriate test (ANOVA or Kruskal-Wallis), performs post-hoc, and visualizes results with compact letter display (CLD). Returns all results as an object with optional console output.
}
\examples{
# Silent operation
results <- run_statdecide(data = df_nonparam, dep_var = "Pollen",
                         group_vars = c("Month","Time"), verbose = FALSE)

# With console output
run_statdecide(data = df_nonparam, dep_var = "Pollen", group_vars = "Month")
}
