
<!-- README.md is generated from README.Rmd. Please edit that file -->

# statdecideR <img src="https://img.shields.io/badge/status-dev-yellow.svg" align="right" height="20"/>

**`statdecideR`** is an R package for **automatic statistical
decision-making**, compact letter displays (CLDs), and beautiful plots
for **parametric and non-parametric tests** — making your analysis both
robust and publication-ready.

## ✨ Features

- Automatically detects normality (Shapiro-Wilk test)
- Chooses appropriate test: ANOVA or Kruskal-Wallis
- Performs post-hoc test: Tukey HSD or Multiple Comparisons (agricolae)
- Displays Compact Letter Display (CLD) results
- Generates clean boxplots, heatmaps, and faceted plots
- Fully reproducible and customizable

## 📦 Installation

``` r
# Development version (from local source or GitHub in future)
# install.packages("devtools")
devtools::install_github("yourusername/statdecideR")
```

> ⚠ Replace `"yourusername"` with your actual GitHub username once
> hosted.

## 🛠️ Usage

``` r
library(statdecideR)

# Load your data
data <- read.csv("your_data.csv")

# Run analysis and plot
plot_with_cld(
  data = data,
  dep_var = "pollen",          # Your dependent variable
  group_var = "month",         # Your independent variable (factor)
  normal = FALSE               # Will be auto-detected in future version
)
```

## 📊 Example Output

The package automatically performs: - Statistical test selection -
Post-hoc analysis (if significant) - Plot with CLD labels

## 📄 License

MIT © [Subhradip Bhattacharjee](mailto:subhradip25@gmail.com)
