% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.cor.test.R
\name{graph.cor.test}
\alias{graph.cor.test}
\title{Test for Association / Correlation Between Paired Samples of Graphs}
\usage{
graph.cor.test(Graphs1, Graphs2)
}
\arguments{
\item{Graphs1}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{Graphs2}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}
}
\value{
A list with class 'htest' containing the following components:
\item{\code{statistic:}}{ the value of the test statistic.}
\item{\code{p.value:}}{ the p-value of the test.}
\item{\code{method:}}{ a string indicating the used method.}
\item{\code{data.name:}}{ a string with the data's name(s).}
\item{\code{estimates:}}{ the estimated measure of association 'rho'.}
}
\description{
\code{graph.cor.test} tests for association between paired samples of graphs,
using Spearman's rho correlation coefficient.
}
\examples{
library(mvtnorm)

set.seed(1)
G1 <- G2 <- list()

p <- mvtnorm::rmvnorm(50, mean=c(0,0), sigma=matrix(c(1, 0.5, 0.5, 1), 2, 2))

ma <- max(p)
mi <- min(p)
p[,1] <- (p[,1] - mi)/(ma - mi)
p[,2] <- (p[,2] - mi)/(ma - mi)

for (i in 1:50) {
  G1[[i]] <- igraph::sample_gnp(50, p[i,1])
  G2[[i]] <- igraph::sample_gnp(50, p[i,2])
}
graph.cor.test(G1, G2)

}
\references{
Fujita, A., Takahashi, D. Y., Balardin, J. B., Vidal, M. C. and Sato, J. R.
(2017) Correlation between graphs with an application to brain network
analysis. _Computational Statistics & Data Analysis_ *109*, 76-92.
}
\keyword{correlation_coefficient}
