% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_kmeans.R
\name{stages_kmeans}
\alias{stages_kmeans}
\title{Learn a staged tree with k-means clustering}
\usage{
stages_kmeans(
  object,
  k = length(object$tree[[1]]),
  algorithm = "Hartigan-Wong",
  transform = sqrt,
  ignore = object$name_unobserved,
  limit = length(object$tree),
  scope = NULL,
  nstart = 1
)
}
\arguments{
\item{object}{an object of class \code{sevt} with fitted probabilities and
data, as returned by \code{full} or \code{sevt_fit}.}

\item{k}{integer or (named) vector: number of clusters, that is stages per variable.
Values will be recycled if needed.}

\item{algorithm}{character: as in \code{\link{kmeans}}.}

\item{transform}{function applied to the probabilities before clustering.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}

\item{limit}{the maximum number of variables to consider.}

\item{scope}{names of the variables to consider.}

\item{nstart}{as in \code{\link{kmeans}}}
}
\value{
A staged event tree.
}
\description{
Build a stage event tree with \code{k} stages for each variable
by clustering (transformed) probabilities with k-means.
}
\details{
\code{kmenas_sevt} performs k-means clustering
to aggregate the stage probabilities of the initial
staged tree \code{object}.
Different values for k can be specified by supplying a
(named) vector to \code{k}.
\code{\link{kmeans}} from the \code{stats} package is used
internally and arguments \code{algorithm} and \code{nstart}
refer to the same arguments as \code{\link{kmeans}}.
}
\examples{
data("Titanic")
model <- stages_kmeans(full(Titanic, join_unobserved = TRUE, lambda = 1), k = 2)
summary(model)
}
