% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ctables.R
\name{make_ctables}
\alias{make_ctables}
\title{Distribute counts along tree}
\usage{
make_ctables(object, data, useNA = "ifany")
}
\arguments{
\item{object}{A stratified event tree, a list with a \code{tree} field.}

\item{data}{table or data.frame containing observations
of the variable in \code{object}.}

\item{useNA}{whether to include NA values in the tables.
Argument passed to \code{\link{table}}.}
}
\value{
A list of \code{ftable}s.
}
\description{
Create the list of \code{ftable}s
storing the observations distributed along
the path of the tree.
}
\details{
Distribute the counts along the event tree.
This is an internal function, the user will
usually just directly fit the staged event tree
model using \code{sevt.fit}.
We refer here to stratified event tree, because actually
the stage information is never used and thus this function
will work for an object with only a \code{tree} field.
}
\keyword{internal}
