#' @importFrom tools toRd
format_bib = function(...) {
  str = vapply(list(...), function(entry) toRd(bibentries[[entry]]), FUN.VALUE = "")
  paste0(str, collapse = "\n\n")
}

#' @importFrom utils bibentry
bibentries       = c(
  Davis2006      = bibentry("article",
    doi          = "10.1093/bioinformatics/btl400",
    year         = "2006",
    month        = "jul",
    publisher    = "Oxford University Press ({OUP})",
    volume       = "22",
    number       = "19",
    pages        = "2356--2363",
    author       = "C. A. Davis and F. Gerick and V. Hintermair and C. C. Friedel and K. Fundel and R. Kuffner and R. Zimmer",
    title        = "Reliable gene signatures for microarray classification: assessment of stability and performance",
    journal      = "Bioinformatics"
  ),

  Zucknick2008   = bibentry("article",
    doi          = "10.2202/1544-6115.1307",
    year         = "2008",
    month        = "jan",
    publisher    = "Walter de Gruyter {GmbH}",
    volume       = "7",
    number       = "1",
    author       = "Manuela Zucknick and Sylvia Richardson and Euan A Stronach",
    title        = "Comparing the Characteristics of Gene Expression Profiles Derived by Univariate and Multivariate Classification Methods",
    journal      = "Statistical Applications in Genetics and Molecular Biology"
  ),

  Bommert2017    = bibentry("article",
    doi          = "10.1155/2017/7907163",
    year         = "2017",
    publisher    = "Hindawi Limited",
    volume       = "2017",
    pages        = "1--18",
    author       = "Andrea Bommert and J\u00f6rg Rahnenf\u00fchrer and Michel Lang",
    title        = "A Multicriteria Approach to Find Predictive and Sparse Models with Stable Feature Selection for High-Dimensional Data",
    journal      = "Computational and Mathematical Methods in Medicine"
  ),

  Bommert2020    = bibentry("inproceedings",
    title        = "Adjusted Measures for Feature Selection Stability for Data Sets with Similar Features",
    author       = "Andrea Bommert and J\u00f6rg Rahnenf\u00fchrer",
    booktitle    = "Machine Learning, Optimization, and Data Science",
    year         = "2020",
    pages        = "203--214",
    doi          = "10.1007/978-3-030-64583-0_19"
  ),

  BommertPHD    = bibentry("phdthesis",
    title        = "Integration of Feature Selection Stability in Model Fitting",
    author       = "Andrea Bommert",
    year         = "2020",
    school       = "TU Dortmund University, Germany",
    doi          = "10.17877/DE290R-21906"
  ),

  LeiYu2012      = bibentry("article",
    doi          = "10.1109/tcbb.2011.47",
    year         = "2012",
    month        = "jan",
    publisher    = "Institute of Electrical and Electronics Engineers ({IEEE})",
    volume       = "9",
    number       = "1",
    pages        = "262--272",
    author       = "Lei Yu and  Yue Han and M. E. Berens",
    title        = "Stable Gene Selection from Microarray Data via Sample Weighting",
    journal      = "{IEEE}/{ACM} Transactions on Computational Biology and Bioinformatics"
  ),

  Zhang2009      = bibentry("article",
    doi          = "10.1093/bioinformatics/btp295",
    year         = "2009",
    month        = "may",
    publisher    = "Oxford University Press ({OUP})",
    volume       = "25",
    number       = "13",
    pages        = "1662--1668",
    author       = "Min Zhang and Lin Zhang and Jinfeng Zou and Chen Yao and Hui Xiao and Qing Liu and Jing Wang and Dong Wang and Chenguang Wang and Zheng Guo",
    title        = "Evaluating reproducibility of differential expression discoveries in microarray studies by considering correlated molecular changes",
    journal      = "Bioinformatics"
  ),

  Dice1945       = bibentry("article",
    doi          = "10.2307/1932409",
    year         = "1945",
    month        = "jul",
    publisher    = "Wiley",
    volume       = "26",
    number       = "3",
    pages        = "297--302",
    author       = "Lee R. Dice",
    title        = "Measures of the Amount of Ecologic Association Between Species",
    journal      = "Ecology"
  ),

  Dunne2002      = bibentry("techreport",
    author       = "Dunne, Kevin and Cunningham, Padraig and Azuaje, Francisco",
    title        = "Solutions to instability problems with sequential wrapper-based approaches to feature selection",
    year         = "2002",
    institution  = "Machine Learning Group, Department of Computer Science, Trinity College, Dublin",
    pages        = "1-22"
  ),

  Jaccard1901    = bibentry("article",
    doi          = "10.5169/SEALS-266450",
    author       = "Jaccard,  Paul",
    title        = "\u00c9tude comparative de la distribution florale dans une portion des Alpes et du Jura",
    journal      = "Bulletin de la Soci\u00e9t\u00e9 Vaudoise des Sciences Naturelles",
    volume       = "37",
    pages        = "547-579",
    publisher    = "Imprimerie Corbaz & Comp.",
    year         = "1901"
  ),

  Novovicov2009  = bibentry("inproceedings",
    doi          = "10.1109/icdmw.2009.32",
    year         = "2009",
    month        = "dec",
    publisher    = "IEEE",
    author       = "Jana Novovi\u010dov\u00e1 and Petr Somol and Pavel Pudil",
    title        = "A New Measure of Feature Selection Algorithms' Stability",
    booktitle    = "2009 {IEEE} International Conference on Data Mining Workshops"
  ),

  Ochiai1957     = bibentry("article",
    doi          = "10.2331/suisan.22.531",
    year         = "1957",
    publisher    = "Japanese Society of Fisheries Science",
    volume       = "22",
    number       = "9",
    pages        = "531-535",
    author       = "Akira Ochiai",
    title        = "Zoogeographical Studies on the Soleoid Fishes Found in Japan and its Neighbouring Regions-{III}",
    journal      = "Nippon Suisan Gakkaishi"
  ),

  Lustgarten2009 = bibentry("inproceedings",
    title        = "Measuring stability of feature selection in biomedical datasets",
    author       = "Lustgarten, Jonathan L and Gopalakrishnan, Vanathi and Visweswaran, Shyam",
    booktitle    = "AMIA annual symposium proceedings",
    volume       = "2009",
    pages        = "406",
    year         = "2009",
    organization = "American Medical Informatics Association"
  ),

  Somol2010      = bibentry("article",
    doi          = "10.1109/tpami.2010.34",
    year         = "2010",
    month        = "nov",
    publisher    = "Institute of Electrical and Electronics Engineers ({IEEE})",
    volume       = "32",
    number       = "11",
    pages        = "1921--1939",
    author       = "Petr Somol and Jana Novovi\u010dov\u00e1",
    title        = "Evaluating Stability and Comparing Output of Feature Selectors that Optimize Feature Subset Cardinality",
    journal      = "{IEEE} Transactions on Pattern Analysis and Machine Intelligence"
  ),

  Nogueira2016   = bibentry("incollection",
    doi          = "10.1007/978-3-319-46227-1_28",
    year         = "2016",
    publisher    = "Springer International Publishing",
    pages        = "442--457",
    author       = "Sarah Nogueira and Gavin Brown",
    title        = "Measuring the Stability of Feature Selection",
    booktitle    = "Machine Learning and Knowledge Discovery in Databases"
  ),

  Carletta1996   = bibentry("article",
    title        = "Assessing Agreement on Classification Tasks: The Kappa Statistic",
    author       = "Carletta, Jean",
    journal      = "Computational Linguistics",
    volume       = "22",
    number       = "2",
    pages        = "249--254",
    year         = "1996",
    publisher    = "MIT Press"
  ),

  Nogueira2018   = bibentry("article",
    author  = "Sarah Nogueira and Konstantinos Sechidis and Gavin Brown",
    title   = "On the Stability of Feature Selection Algorithms",
    journal = "Journal of Machine Learning Research",
    year    = "2018",
    volume  = "18",
    number  = "174",
    pages   = "1--54",
    url     = "https://jmlr.org/papers/v18/17-514.html"
  ),

  Sechidis2020   = bibentry("incollection",
    doi          = "10.1007/978-3-030-46150-8_20",
    year         = "2020",
    publisher    = "Springer International Publishing",
    pages        = "327--342",
    author       = "Konstantinos Sechidis and Konstantinos Papangelou and Sarah Nogueira and James Weatherall and Gavin Brown",
    title        = "On the Stability of Feature Selection in the Presence of Feature Correlations",
    booktitle    = "Machine Learning and Knowledge Discovery in Databases"
  ),

  Wald2013       = bibentry("inproceedings",
    doi          = "10.1109/ictai.2013.63",
    year         = "2013",
    month        = "nov",
    publisher    = "IEEE",
    author       = "Randall Wald and Taghi M. Khoshgoftaar and Amri Napolitano",
    title        = "Stability of Filter- and Wrapper-Based Feature Subset Selection",
    booktitle    = "2013 {IEEE} 25th International Conference on Tools with Artificial Intelligence"
  )
)
