% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreg_ber.R
\name{sreg_ber}
\alias{sreg_ber}
\title{Semiparametric Model-Assisted Estimation under a Bernoulli Sampling Design}
\usage{
sreg_ber(location_formula, scale_formula, data, pi, ...)
}
\arguments{
\item{location_formula}{a symbolic description of the systematic component of the location model to be fitted.}

\item{scale_formula}{a symbolic description of the systematic component of the scale model to be fitted.}

\item{data}{a data frame, list containing the variables in the model.}

\item{pi}{numeric, represents the first order probability. Default value is 0.5.}

\item{...}{further parameters accepted by caret and survey functions.}
}
\value{
\code{sampling_design} is the name of the sampling design used in the estimation process.

\code{N} is the population size.

\code{n} is the random sample size used in the estimation process.

\code{first_order_probabilities} vector of the first order probabilities used in the estimation process.

\code{sample} is the random sample used in the estimation process.

\code{estimated_total_y_sreg} is the SREG estimate of the total parameter of the finite population.
}
\description{
\code{sreg_ber} is used to estimate the total parameter of a finite population generated from a semi-parametric generalized gamma population under a Bernoulli sampling design.
}
\examples{
#This example use the data set 'apipop' of the survey package.
library(sregsurvey)
library(survey)
library(magrittr)
library(dplyr)
library(gamlss)
data(api)
attach(apipop)
Apipop <- filter(apipop,full!= 'NA')
Apipop <- filter(Apipop, stype == 'H')
Apipop <- Apipop \%>\% dplyr::select(api00,grad.sch,full)
fit <- sreg_ber(api00 ~  pb(grad.sch), scale_formula = ~ full - 1, data= Apipop, pi=0.2)
fit
# The total population value is
true_total <- sum(Apipop$api00)
# The estimated relative bias in percentage is
round(abs((fit$estimated_total_y_sreg - true_total)/true_total),3)*100
}
\references{
Cardozo C.A, Alonso C. (2021) Semi-parametric model assisted estimation in finite populations. In preparation.

Cardozo C.A.,  Paula G., and Vanegas L. (2022). Generalized log-gamma additive partial linear models with P-spline smoothing. Statistical Papers.

Sarndal C.E.,  Swensson B., and Wretman J. (2003). Model Assisted Survey Sampling. Springer-Verlag.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
