% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_to_intMask.R
\name{int_to_intMask}
\alias{int_to_intMask}
\title{Integer to Vector Bitmask}
\usage{
int_to_intMask(i, length)
}
\arguments{
\item{i}{A 32 bit integer}

\item{length}{Integer length of the bitmask to produce, must be <= 32}
}
\value{
A vector of integer containing 1 or 0
}
\description{
Converts the bit representation of an integer into a vector of integers
}
\details{
Converts an integer to a vector of ones and zeroes.  Used as a helper
function for full_embedding_search, it allows more compact storage of bit masks.
The result reads left to right, so the one bit will have index of one in the
vector corresponding to lag 1 in an embedding.  Works for masks up
to 32 bits
}
\examples{
he <- embed(henon_x, 17)
t <- he[ , 1]
p <- he[ ,2:17]
mask <- int_to_intMask(7, 16)     # pick out the first three columns
pn <- select_by_mask(p, mask)
gamma_test(predictors = pn, target = t)
}
