% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_localsrq.R
\name{methods_localsrq}
\alias{methods_localsrq}
\alias{print.localsrq}
\alias{plot.localsrq}
\title{Methods for class localsrq}
\usage{
\method{print}{localsrq}(x, ...)

\method{plot}{localsrq}(x, ..., sf = NULL, coor = NULL, sig = 0.05)
}
\arguments{
\item{x}{a \code{localsrq} object created by \code{\link{Q.test}}.}

\item{...}{further arguments passed to or from other methods.}

\item{sf}{optional argument for \code{plot()} method to include a sf object (default = NULL)}

\item{coor}{optional argument for \code{plot()} method to include coordinates of points (default = NULL)}

\item{sig}{significant level for each observation in \code{plot()} method. Default \code{sig = 0.05}}
}
\value{
No return value, called for side effects
}
\description{
The \code{plot()} function allows the user to plot significant observations.
The \code{print()} function is used to print the number of runs in each localization. Additional information of
expected values and standard deviation, z-value ans p-value is prited for each observation.
}
\examples{
# Example 1: Local spatial runs test based on knn
N <- 100
cx <- runif(N)
cy <- runif(N)
x <- cbind(cx,cy)
listw <- spdep::knearneigh(cbind(cx,cy), k = 10)
p <- c(1/6,3/6,2/6)
rho <- 0.5
fx <- dgp.spq(p = p, listw = listw, rho = rho)

# Asymtotic version
lsrq <- local.sp.runs.test(fx = fx, listw = listw, alternative = "less")
print(lsrq)
plot(lsrq, sig = 0.05)

}
\references{
\itemize{
\item Ruiz, M., López, F., and Páez, A. (2021).
A test for global and local homogeneity of categorical data based on spatial runs.
\emph{working paper}.
}
}
\author{
\tabular{ll}{
Fernando López  \tab \email{fernando.lopez@upct.es} \cr
Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
Antonio Páez \tab \email{paezha@gmail.com} \cr
Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
}
}
