% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spocc-package.R
\name{spocc-package}
\alias{spocc-package}
\title{Interface to many species occurrence data sources}
\description{
A programmatic interface to many species occurrence data
sources, including GBIF, iNaturalist, Berkeley Ecoinformatics
Engine, eBird, iDigBio, VertNet, OBIS, and ALA. Includes
functionality for retrieving species occurrence data, and
combining that data.
}
\section{Package API}{


The main function to use is \code{\link[=occ]{occ()}} - a single interface to
many species occurrence databases (see below for a list).

Other functions include:
\itemize{
\item \code{\link[=occ2df]{occ2df()}} - Combine results from \code{occ} into a
data.frame
\item \code{\link[=wkt_vis]{wkt_vis()}} - Visualize WKT strings (used to define
geometry based searches for some data sources) in an interactive map
}
}

\section{Currently supported species occurrence data sources}{


\tabular{ll}{
Provider \tab Web \cr
GBIF \tab \url{https://www.gbif.org/} \cr
eBird \tab \url{http://ebird.org/content/ebird/} \cr
iNaturalist \tab \url{https://www.inaturalist.org/} \cr
VertNet \tab \url{http://vertnet.org/} \cr
iDigBio \tab \url{https://www.idigbio.org/} \cr
OBIS \tab \url{https://www.obis.org/} \cr
ALA \tab \url{https://www.ala.org.au/}
}
}

\section{Duplicates}{


See \code{\link[=spocc_duplicates]{spocc_duplicates()}} for more.
}

\section{Clean data}{


All data cleaning functionality is in as archived package: \code{scrubr}
(\url{https://github.com/ropensci-archive/scrubr}).
On CRAN: \url{https://cran.r-project.org/src/contrib/Archive/scrubr/}.
See also package
\url{https://cran.r-project.org/package=CoordinateCleaner}
}

\section{Make maps}{


All mapping functionality is now in a separate package: \verb{mapr`` (<https://github.com/ropensci/mapr>) (formerly known as }spoccutils`).
On CRAN: \url{https://cran.r-project.org/package=mapr}
}

\author{
Scott Chamberlain
}
\keyword{package}
