% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryLomb.R
\name{summary.lomb}
\alias{summary.lomb}
\title{Summarize Lomb objects}
\usage{
\method{summary}{lomb}(object, p0 = 0.01, ...)
}
\arguments{
\item{object}{\code{lomb} object}

\item{p0}{False Alarm Probability threshold, default 1\%}

\item{...}{not used}
}
\value{
a list of significant values of the spectral analysis
}
\description{
The function summarizes properties from the Lomb object.
}
\details{
The false alarm probability threshold \code{p0} value will
adjust the number of peaks.

The \code{effectiveBandWidth} describes the coverage of processed
frequencies by the \code{spec.lomb} function. If the ratio to
\code{averageSampling} is almost 2, then the Nyquist criterion can
be assumed to be fullfilled. If the ratio is much less than 2
then only a fraction of information is analysed.

The \code{minFreqStep} is an estimate of the minimum frequency
step determined from the Lomb-Object.

Average sampling is calculated from the median distance between
two spatial points.

The possible frequency resolution originates also from the spatial
(temporal) input data by \code{1/(diff(range(x)))}, if \code{x} is
the spatial (temporal) coordinate.
}
\examples{
# see spec.lomb() example
}
