% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{se_compare}
\alias{se_compare}
\title{Compare different kinds of standard errors}
\usage{
se_compare(
  formula,
  data,
  weights = NULL,
  types = "all",
  cluster = NULL,
  clusteredOnly = FALSE,
  fixedEffectsOnly = FALSE,
  bootSamples = NULL,
  bootSampleSize = NULL
)
}
\arguments{
\item{formula}{A string containing a regression formula, with or without
fixed effects.}

\item{data}{A data frame containing the variables provided in `formula` and
any clustering variables passed to `cluster`.}

\item{weights}{Optional string with the column name in `data` that contains
weights.}

\item{types}{A string or vector of strings specifying what types of
             standard errors are desired. Defaults to "all".

             The following types are supported for non-fixed effects models:

               With clustering: "HC0, "HC1", "HC2", "HC3".

               Without clustering: "iid" (i.e. normal standard errors),
                                   "HC0, "HC1", "HC2", "HC3",
                                   "HC4", "HC4m", "HC5",
                                   "bootstrapped".

             The following types are supported for fixed effects models:

               With clustering: "CL_FE" (clustered by fixed effects, i.e.
                                the default standard errors reported by
                                `feols()` if no clusters are supplied), if
                                clusters are supplied then the conventional
                                clustered standard errors from `feols()` are
                                estimated for each clustering variable. Two-
                                way clustered standard errors are not
                                supported at this time.

               Without clustering: "HC0, "HC1", "HC2", "HC3",
                                   "HC4", "HC4m", "HC5",
                                   "bootstrapped".}

\item{cluster}{A string or vector of strings specifying variables present in
`data` to be used for clustering standard errors.}

\item{clusteredOnly}{A boolean indicating whether only standard errors with
clustering should be estimated, defaults to `FALSE`.}

\item{fixedEffectsOnly}{A boolean indicating whether only standard errors for
fixed effects models should be estimated, defaults to
`FALSE`.}

\item{bootSamples}{An integer or vector of integers indicating how many times
the model should be estimated with a random subset of the
data. If a vector then every combination of `bootSamples`
and `bootSampleSize` are estimated.}

\item{bootSampleSize}{An integer or vector of integers indicating how many
observations are in each random subset of the data.
If a vector then every combination of `bootSamples`
and `bootSampleSize` are estimated.}
}
\value{
A data frame where row represents an independent variable in the
        model and each column a type of standard error. Coefficient estimates
        for each variable are also included (column `"estimate"` for
        non-fixed effects model and column `"estimate_FE"` for fixed effects
        models). Columns are automatically named to specify the standard
        error type.

        Some examples:

         "iid" = normal standard errors, i.e. assuming homoskedasticity

         "CL_FE" = standard errors clustered by fixed effects

         "bootstrap_k8n300_FE" =  bootstrapped standard errors for a fixed
                                  effects model where `bootSamples = 8` and
                                  `bootSampleSize = 300`

         "CL_Depth_ID_FE" = standard errors clustered by the variable
                              "Depth_ID" for a model with fixed effects

         "HC0_Sta_ID" = HC0 standard errors clustered by the variable
                          "Sta_ID"

         Note: for fixed effects models the "(Intercept)" row will be all
         `NA` because the intercept is not reported by `feols()` when fixed
         effects are present.
}
\description{
se_compare() takes in a regression formula (with or without fixed effects),
data, and the types of standard errors desired, including clustered,
heteroskedasticity-consistent, and bootstrapped. It then returns a data
frame with coefficient and standard error estimates for easy comparison and
plotting.
}
\examples{

se_compare(formula = "Salnty ~ T_degC + ChlorA + O2Sat | Sta_ID",
           data = bottles, types = "all", cluster = c("Depth_ID", "Sta_ID"),
           fixedEffectsOnly = FALSE, bootSamples=c(4, 8, 10),
           bootSampleSize=c(300, 500))

se_compare(formula = "Salnty ~ T_degC + ChlorA + O2Sat", data = bottles,
           types = "bootstrapped", bootSamples = c(8, 10),
           bootSampleSize = c(300, 500))

se_compare(formula = "Salnty ~ T_degC + ChlorA", data = bottles,
           types = c("HC0", "HC1", "HC3"))

}
