% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nagelkerke_r2_lm.r
\name{nagelkerke_r2_lm}
\alias{nagelkerke_r2_lm}
\title{Calculate Nagelkerke pseudo R-squared for a linear model}
\usage{
nagelkerke_r2_lm(model)
}
\arguments{
\item{model}{An object of class \code{lm}.}
}
\value{
A numeric value representing the Nagelkerke pseudo R-squared.
}
\description{
This function computes the Nagelkerke pseudo R-squared for a linear model (`lm` object)
by comparing the log-likelihood of the fitted model to that of the null model (intercept-only).
}
\details{
Nagelkerke R² is a normalized version of the likelihood ratio R², scaled to have a maximum of 1.
It is commonly used for generalized linear models but can also be applied to linear models.

The formula used is: 
\deqn{R^2_{Nagelkerke} = \frac{1 - \exp\left(\frac{2}{n} (LL_{null} - LL_{model})\right)}{1 - \exp\left(\frac{2}{n} LL_{null}\right)}}
where \eqn{LL_{model}} is the log-likelihood of the fitted model and \eqn{LL_{null}} is the log-likelihood of the null model.
}
\examples{
data(mtcars)
fit <- lm(mpg ~ wt + hp, data = mtcars)
nagelkerke_r2_lm(fit)

}
\references{
Nagelkerke, N. J. D. (1991). A note on a general definition of the coefficient of determination. \emph{Biometrika}, 78(3), 691–692.
}
