% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_power.R
\name{spatial_power}
\alias{spatial_power}
\title{Power of SRR function for randomly generated data.}
\usage{
spatial_power(
  win = spatstat.geom::unit.square(),
  sim_total = 2,
  x_case,
  y_case,
  samp_case = c("uniform", "MVN", "CSR", "IPP"),
  samp_control = c("uniform", "systematic", "MVN", "CSR", "IPP", "clustered"),
  x_control = NULL,
  y_control = NULL,
  n_case = NULL,
  n_control = NULL,
  npc_control = NULL,
  r_case = NULL,
  r_control = NULL,
  s_case = NULL,
  s_control = NULL,
  l_case = NULL,
  l_control = NULL,
  e_control = NULL,
  alpha = 0.05,
  p_correct = "none",
  verbose = TRUE,
  parallel = FALSE,
  n_core = 2,
  ...,
  cascon = lifecycle::deprecated(),
  lower_tail = lifecycle::deprecated(),
  upper_tail = lifecycle::deprecated()
)
}
\arguments{
\item{win}{Window in which to simulate the random data. An object of class "owin" or something acceptable to \code{\link[spatstat.geom]{as.owin}}.}

\item{sim_total}{Integer, specifying the number of simulation iterations to perform.}

\item{x_case}{Numeric value, or numeric vector, of x-coordinate(s) of case cluster(s).}

\item{y_case}{Numeric value, or numeric vector, of y-coordinate(s) of case cluster(s).}

\item{samp_case}{Character string specifying whether to randomize the case locations uniformly (\code{samp_control="uniform"}), multivariate normal (\code{samp_control="MVN"}), with complete spatial randomness (\code{samp_control="CSR"}), or using the inhomogeneous Poisson process (\code{samp_control="IPP"}) around each case centroid.}

\item{samp_control}{Character string specifying whether to randomize the control locations uniformly (\code{samp_control="uniform"}), systematically (\code{samp_control="systematic"}), multivariate normal (\code{samp_control="MVN"}), with complete spatial randomness (\code{samp_control="CSR"}), using the inhomogeneous Poisson process (\code{samp_control="IPP"}), or a realization of the Neyman-Scott cluster process (\code{samp_control="clustered"}).}

\item{x_control}{Numeric value, or numeric vector, of x-coordinate(s) of case cluster(s). Ignored if \code{samp_control!="MVN"}.}

\item{y_control}{Numeric value, or numeric vector, of y-coordinate(s) of case cluster(s). Ignored if \code{samp_control!="MVN"}.}

\item{n_case}{Numeric value, or numeric vector, of the sample size for case locations in each cluster.}

\item{n_control}{Numeric value, or numeric vector, of the sample size for control locations in each cluster.}

\item{npc_control}{Optional. Numeric value of the number of clusters of control locations. Ignored if \code{samp_control!="clustered"}.}

\item{r_case}{Optional. Numeric value, or numeric vector, of radius (radii) of case cluster(s) in the units of \code{win}. Ignored if \code{samp_case="MVN"}.}

\item{r_control}{Optional. Numeric value, or numeric vector, of radius (radii) of control cluster(s) in the units of \code{win}. Ignored if \code{samp_control!="clustered"}.}

\item{s_case}{Optional. Numeric value, or numeric vector, for the standard deviation(s) of the multivariate normal distribution for case locations in the units of \code{win}. Ignored if \code{samp_control!="MVN"}.}

\item{s_control}{Optional. Numeric value, or numeric vector, for the standard deviation(s) of the multivariate normal distribution for control locations in the units of \code{win}. Ignored if \code{samp_control!="MVN"}.}

\item{l_case}{Optional. A single positive number, a vector of positive numbers, a function(x,y, ...), or a pixel image. Intensity of the Poisson process for case clusters. Ignored if \code{samp_control!="IPP"}.}

\item{l_control}{Optional. A single positive number, a vector of positive numbers, a function(x,y, ...), or a pixel image. Intensity of the Poisson process for control clusters. Ignored if \code{samp_control="uniform"}, \code{samp_control="systematic"}, \code{samp_control="MVN"}, or \code{samp_control="CSR"}.}

\item{e_control}{Optional. A single non-negative number for the size of the expansion of the simulation window for generating parent points. Ignored if \code{samp_control!="clustered"}.}

\item{alpha}{Optional. Numeric value of the critical p-value (default=0.05).}

\item{p_correct}{Optional. Character string specifying whether to apply a correction for multiple comparisons including a False Discovery Rate \code{p_correct = "FDR"}, a Sidak correction \code{p_correct = "uncorrelated Sidak"}, and a Bonferroni correction \code{p_correct = "uncorrelated Bonferroni"}. If \code{p_correct = "none"} (the default), then no correction is applied.}

\item{verbose}{Logical. If TRUE (the default), will print function progress during execution. If FALSE, will not print.}

\item{parallel}{Logical. If TRUE, will execute the function in parallel. If FALSE (the default), will not execute the function in parallel.}

\item{n_core}{Optional. Integer specifying the number of CPU cores on current host to use for parallelization (the default is 2 cores).}

\item{...}{Arguments passed to \code{\link[spatstat.random]{runifdisc}}, \code{\link[spatstat.geom]{disc}}, \code{\link[spatstat.random]{rpoispp}}, \code{\link[spatstat.geom]{rsyst}}, or \code{\link[spatstat.random]{rNeymanScott}} depending on \code{samp_control} or \code{samp_control}. Arguments also passed to \code{\link[sparr]{risk}} to select bandwidth, edge correction, and resolution.}

\item{cascon}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{cascon} is no longer supported and this function will output power for case-only and case/control clustering. This argument has been moved to \code{spatial_plots} function.}

\item{lower_tail}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{lower_tail} is no longer supported; this function uses \code{alpha} to set the critical p-value.}

\item{upper_tail}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{lupper_tail} is no longer supported; this function uses \code{alpha} to set the critical p-value.}
}
\value{
An object of class "list". This is a named list with the following components:

\describe{
\item{\code{sim}}{An object of class 'rrs' for the first iteration of simulated data.}
\item{\code{out}}{An object of class 'rrs' for the observed spatial relative risk function without randomization.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the mean relative risk values at each gridded knot.}
\item{\code{pval_mean}}{Vector of length \code{[resolution x resolution]} of the mean asymptotic p-value at each gridded knot.}
\item{\code{rr_sd}}{Vector of length \code{[resolution x resolution]} of the standard deviation of relative risk values at each gridded knot.}
\item{\code{pval_prop_cascon}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant for both case and control locations at each gridded knot.}
\item{\code{pval_prop_cas}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant for only case locations at each gridded knot.}
\item{\code{rx}}{Vector of length \code{[resolution x resolution]} of the x-coordinates of each gridded knot.}
\item{\code{ry}}{Vector of length \code{[resolution x resolution]} of the y-coordinates of each gridded knot.}
\item{\code{n_cas}}{Vector of length \code{sim_total} of the number of case locations simulated in each iteration.}
\item{\code{n_con}}{Vector of length \code{sim_total} of the number of control locations simulated in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the bandwidth (of numerator) used in each iteration.}
\item{\code{s_obs}}{Vector of length \code{sim_total} of the global s statistic.}
\item{\code{t_obs}}{Vector of length \code{sim_total} of the global t statistic.}
\item{\code{alpha}}{Vector of length \code{sim_total} of the (un)corrected critical p-values.}
}
}
\description{
Compute the statistical power of a spatial relative risk function using randomly generated data.
}
\details{
This function computes the statistical power of the spatial relative risk function (nonparametric estimate of relative risk by kernel smoothing) for randomly generated data using various random point pattern generators from the \code{\link[spatstat.random]{spatstat.random}} package.

The function uses the \code{\link[sparr]{risk}} function to estimate the spatial relative risk function and forces the \code{tolerate} argument to be TRUE in order to calculate asymptotic p-values.

If \code{samp_case = "uniform"} the case locations are randomly generated uniformly within a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}).

If \code{samp_case = "MVN"} the case locations are randomly generated assuming a multivariate normal distribution centered at coordinates (\code{x_case}, \code{y_case}) with a standard deviation of \code{s_case}.

If \code{samp_case = "CSR"} the case locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}) with \code{lambda = n_case / area of disc}.

If \code{samp_case = "IPP"} the case locations are randomly generated assuming an inhomogeneous Poisson process with a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}) with \code{lambda = l_case}, a function.

If \code{samp_control = "uniform"} the control locations are randomly generated uniformly within the window \code{win}.

If \code{samp_control = "systematic"} the control locations are randomly generated systematically within the window \code{win} consisting of a grid of equally-spaced points with a random common displacement.

If \code{samp_control = "MVN"} the control locations are randomly generated assuming a multivariate normal distribution centered at coordinates (\code{x_control}, \code{y_control}) with a standard deviation of \code{s_control}.

If \code{samp_control = "CSR"} the control locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within the window \code{win} with a \code{lambda = n_control / [resolution x resolution]} By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "IPP"} the control locations are randomly generated assuming an inhomogeneous Poisson process within the window \code{win} with a \code{lambda = l_control}, a function.

If \code{samp_control = "clustered"} the control locations are randomly generated with a realization of the Neyman-Scott process within the window \code{win} with the intensity of the Poisson process cluster centres (\code{kappa = l_control}), the size of the expansion of the simulation window for generative parent points (\code{e_control}), and the radius (or radii) of the disc for each cluster (\code{r_control}).

The function computes a one-sided hypothesis test for case clustering (\code{alpha = 0.05} by default). The function also computes a two-sided hypothesis test for case clustering and control clustering (lower tail = 0.025 and upper tail = 0.975).

The function has functionality for a correction for multiple testing. If \code{p_correct = "FDR"}, calculates a False Discovery Rate by Benjamini and Hochberg. If \code{p_correct = "Sidak"}, calculates a Sidak correction. If \code{p_correct = "Bonferroni"}, calculates a Bonferroni correction. If \code{p_correct = "none"} (the default), then the function does not account for multiple testing and uses the uncorrected \code{alpha} level. See the internal \code{pval_correct} function documentation for more details.
}
\examples{
 spatial_power(x_case = c(0.25, 0.5, 0.75),
               y_case = c(0.75, 0.25, 0.75),
               samp_case = "MVN", 
               samp_control = "MVN",
               x_control = c(0.25, 0.5, 0.75),
               y_control = c(0.75, 0.25, 0.75),
               n_case = 100,
               n_control = c(100,500,300),
               s_case = c(0.05,0.01,0.05),
               s_control = 0.05,
               verbose = FALSE)

}
